const { ccclass, property } = cc._decorator;

@ccclass
export default class Test extends cc.Component {

    private rect1: cc.Node;
    private rect2: cc.Node;

    protected start(): void {
        this.rect1 = this.node.getChildByName("rect1");
        this.rect2 = this.node.getChildByName("rect2");

        let oldP: cc.Vec2;
        this.rect2.on(cc.Node.EventType.TOUCH_START, (evt: cc.Event.EventTouch) => {
            oldP = evt.getLocation();
        });
        this.rect2.on(cc.Node.EventType.TOUCH_MOVE, (evt: cc.Event.EventTouch) => {
            const p = evt.getLocation();
            this.rect2.x += p.x - oldP.x;
            this.rect2.y += p.y - oldP.y;
            oldP = p;

            if (
                this.rect1.x + this.rect1.width / 2 < this.rect2.x - this.rect2.width / 2 ||
                this.rect1.x - this.rect1.width / 2 > this.rect2.x + this.rect2.width / 2 ||
                this.rect1.y + this.rect1.height / 2 < this.rect2.y - this.rect2.height / 2 ||
                this.rect1.y - this.rect1.height / 2 > this.rect2.y + this.rect2.height / 2
            ) {
                this.rect1.color = cc.Color.BLUE;
                this.rect2.color = cc.Color.GREEN;
            } else {
                this.rect1.color = cc.Color.RED;
                this.rect2.color = cc.Color.RED;
            }
        });
    }

}
