const { ccclass, property } = cc._decorator;

@ccclass
export default class Test extends cc.Component {

    private ball1: Ball;
    private ball2: Ball;

    protected start(): void {
        this.ball1 = new Ball(this.node.getChildByName("ball1"), this.node.getChildByName("center1"), 1);
        this.ball2 = new Ball(this.node.getChildByName("ball2"), this.node.getChildByName("center2"), 10);
    }

    protected update(): void {
        this.ball1.step();
        this.ball2.step();
    }

}

const k = 0.01;

class Ball {

    private node: cc.Node;
    private center: cc.Node;

    private seg: number;

    private vx: number;
    private vy: number;

    public constructor(node: cc.Node, center: cc.Node, seg: number) {
        this.node = node;
        this.center = center;

        let oldP: cc.Vec2;
        this.center.on(cc.Node.EventType.TOUCH_START, (evt: cc.Event.EventTouch) => {
            oldP = evt.getLocation();
        });
        this.center.on(cc.Node.EventType.TOUCH_MOVE, (evt: cc.Event.EventTouch) => {
            const p = evt.getLocation();
            this.center.x += p.x - oldP.x;
            this.center.y += p.y - oldP.y;
            oldP = p;
        });
        
        this.node.x = this.center.x + 150;
        this.node.y = this.center.y + 200;

        this.seg = seg;
        this.vx = this.vy = 0;
    }

    public step(): void {
        const part = 1 / this.seg;
        for (let i: number = 0; i < this.seg; i++) {
            const dx = this.center.x - this.node.x;
            const dy = this.center.y - this.node.y;
            this.vx += k * part * dx * part;
            this.vy += k * part * dy * part;
            this.node.x += this.vx;
            this.node.y += this.vy;
        }
    }

}
