const { ccclass, property } = cc._decorator;

@ccclass
export default class Test extends cc.Component {

    private wid2 = 1136 / 2;
    private hei2 = 640 / 2;
    private r: number = 32;
    private left: number = -this.wid2 + this.r;
    private right: number = this.wid2 - this.r;
    private bottom: number = -this.hei2 + this.r;
    private top: number = this.hei2 - this.r;
    private g: number = -1;
    private ux: number = 0.99;
    private uy: number = 0.95;
    private vx: number;
    private vy: number;

    private ball: cc.Node;

    protected start(): void {
        this.ball = this.node.getChildByName("ball");
        this.ball.on(cc.Node.EventType.TOUCH_START, (evt: cc.Event.EventTouch) => {
            const p = this.ball.convertToNodeSpaceAR(evt.getLocation());
            this.vx = -p.x;
            this.vy = -p.y;
        });
        this.vx = 4;
        this.vy = 0;
    }

    protected update(): void {
        this.ball.x += this.vx;
        this.vx *= this.ux;
        this.vy += this.g;
        this.vy *= this.uy;
        if (this.vx * this.vx < 0.1) this.vx = 0;
        this.ball.y += this.vy;
        if (this.vx < 0) {
            if (this.ball.x <= this.left) {
                this.ball.x = this.left;
                this.vx *= -1;
            }
        } else {
            if (this.ball.x >= this.right) {
                this.ball.x = this.right;
                this.vx *= -1;
            }
        }
        if (this.vy < 0) {
            if (this.ball.y <= this.bottom) {
                this.ball.y = this.bottom;
                this.vy *= -1;
                if (this.vy * this.vy < 0.01) this.vy = 0;
            }
        } else {
            if (this.ball.y >= this.top) {
                this.ball.y = this.top;
                this.vy *= -1;
                if (this.vy * this.vy < 0.01) this.vy = 0;
            }
        }
    }

}
