const { ccclass, property } = cc._decorator;

@ccclass
export default class Test extends cc.Component {

    private wid2 = 1136 / 2;
    private hei2 = 640 / 2;
    private r: number = 32;
    private left: number = -this.wid2 + this.r;
    private right: number = this.wid2 - this.r;
    private bottom: number = -this.hei2 + this.r;
    private top: number = this.hei2 - this.r;
    private v0: number = 10;
    private dirX: -1 | 0 | 1;
    private dirY: -1 | 0 | 1;
    private sqrt2 = Math.sqrt(2);

    private ball: cc.Node;

    protected start(): void {
        this.ball = this.node.getChildByName("ball");
        this.dirX = 0;
        this.dirY = 0;

        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, (evt: { keyCode: number }) => {
            switch (evt.keyCode) {
                case cc.macro.KEY.a:
                case cc.macro.KEY.left:
                    this.dirX = -1;
                    break;
                case cc.macro.KEY.w:
                case cc.macro.KEY.up:
                    this.dirY = 1;
                    break;
                case cc.macro.KEY.d:
                case cc.macro.KEY.right:
                    this.dirX = 1;
                    break;
                case cc.macro.KEY.s:
                case cc.macro.KEY.down:
                    this.dirY = -1;
                    break;
            }
        });
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP, (evt: { keyCode: number }) => {
            switch (evt.keyCode) {
                case cc.macro.KEY.a:
                case cc.macro.KEY.left:
                    if (this.dirX == -1) this.dirX = 0;
                    break;
                case cc.macro.KEY.w:
                case cc.macro.KEY.up:
                    if (this.dirY == 1) this.dirY = 0;
                    break;
                case cc.macro.KEY.d:
                case cc.macro.KEY.right:
                    if (this.dirX == 1) this.dirX = 0;
                    break;
                case cc.macro.KEY.s:
                case cc.macro.KEY.down:
                    if (this.dirY == -1) this.dirY = 0;
                    break;
            }
        });
    }

    protected update(): void {
        if (this.dirX == 0 || this.dirY == 0) {
            this.ball.x += this.dirX * this.v0;
            this.ball.y += this.dirY * this.v0;
        } else {
            this.ball.x += this.dirX * this.v0 / this.sqrt2;
            this.ball.y += this.dirY * this.v0 / this.sqrt2;
        }
        if (this.dirX < 0) {
            if (this.ball.x <= this.left) {
                this.ball.x = this.left;
            }
        } else {
            if (this.ball.x >= this.right) {
                this.ball.x = this.right;
            }
        }
        if (this.dirY < 0) {
            if (this.ball.y <= this.bottom) {
                this.ball.y = this.bottom;
            }
        } else {
            if (this.ball.y >= this.top) {
                this.ball.y = this.top;
            }
        }
    }

}
